<?php 
   /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    include "classi/Cruscotto.php";
    
    if(isset($_GET["id"])) {
        $cruscotto = new Cruscotto($geecomDb, filter_input(INPUT_GET, "id",FILTER_SANITIZE_NUMBER_INT));
        $cruscotto->caricaDatiDalDatabase();
    }
    else {
        $cruscotto = new Cruscotto($geecomDb, 0);
    }
    
    if(isset($_GET["status"])) {
        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
    }
    else {
        $status = 0;
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom Admin - Creazione Cruscotto</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>

        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">
                <div class="row py-4">
                    <?php 
                        if($status==200) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Cruscotto creato
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        
                        if($status==250) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Cruscotto modificato
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                    ?>
                    <div class="col-12">
                        <div class="Cruscotto-row justify-content-between mb-3">
                            <div class="col-auto d-flex">
                                <nav aria-label="breadcrumb" class="align-self-center">
                                    <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                        <li class="breadcrumb-item"><a href="../../home.php">Home</a></li>
                                        <li class="breadcrumb-item"><a href="#" data-toggle="modal" data-target="#menu-componenti">Componenti</a></li>
                                        <li class="breadcrumb-item"><a href="index.php">Cruscotto</a></li>
                                        <li class="breadcrumb-item active" aria-current="page"><?= (isset($cruscotto) && $cruscotto->getNome()!="") ? $cruscotto->getNome() : "Nuovo cruscotto" ?></li>

                                    </ol>
                                </nav>
                            </div>
                            <div class="col-auto text-right">
                                <a class="btn btn-outline-primary" href="index.php"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                <button class="btn btn-primary" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                                <button type="button" class="btn btn-warning" onclick="location.href='controller/controllerComponente.php?id=1&amp;operazione=duplica';"><i class="far fa-clone mr-2"></i>Duplica</button>
                            </div>
                        </div>
                        <div class="card mb-4 box-shadow-lite">
                            <form name="formComponente" action="controller/controllerComponente.php" method="post">
                                <input type="text" class="d-none" name="operazione" value="<?php echo((isset($cruscotto) && $cruscotto->getId()!=0) ? "modifica" : "crea"); ?>">
                                <input type="text" class="d-none" name="id" value="<?php echo((isset($cruscotto) ? $cruscotto->getId() : "0")); ?>">
                                
                                <div class="card-body">
                                    <div class="row">
		                            <div class="col-md-6 Cruscotto-group">
		                                    <label>Nome</label>
		                                    <input type="text" class="form-control" id="nomeSlider" name="nome" aria-describedby="nome griglia" value="<?php echo((isset($cruscotto) ? $cruscotto->getNome() : "")) ?>" placeholder="Nome occorrenza">
		                            </div>
		                                        
		                            <div class="col-md-3 form-group">
		                                <label>Spazio occupato</label>
		                                <select class="form-control" name="spazioOccupato">
		                                    <?php 
		                                        foreach($arrayDimensioniColonna as $classe=>$descrizione) {
		                                            if(isset($cruscotto) && $cruscotto->getSpazioOccupato()==$classe) {
		                                                echo"<option value=\"$classe\" selected>$descrizione</option>";
		                                            }
		                                            else {
		                                                echo"<option value=\"$classe\">$descrizione</option>";
		                                            }
		                                        }
		                                    ?>
		                                </select>
		                                <small class="text-muted">Lo spazio orizzontale occupato dal componente</small>
		                            </div>
                                    </div>
                                </div>
                            </form>
                            <div class="card-footer">
                                <button type="button" class="btn btn-primary float-right" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                            </div>
                        </div>
                        <div class="card mb-4 box-shadow-lite">
                            <?php 
                                if(isset($cruscotto) && $cruscotto->getId()>0) {
                            ?>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-lg-4 col-xl-3">
                                        <form>
                                            <div class="mb-4 add-box align-self-start sticky-top">
                                                <h5 class="mb-3"> Aggiungi elemento </h5>
                                                <div class="options-box">
                                                    <div class="form-group">
                                                        <label>Nome</label>
                                                        <input type="text" class="form-control" id="nomeElemento" placeholder="Nome">
                                                    </div>

                                                    <div class="form-group">
                                                        <label>Stile</label>
                                                        <select id="tipoElemento" class="form-control">
                                                            <?php 
                                                                $stiliDisponibili = array("Aspetto 1","Aspetto 2");
                                                                foreach($stiliDisponibili as $stile) {
                                                                    echo"<option value=\"$stile\">$stile</option>";
                                                                }
                                                            ?>
                                                        </select>
                                                    </div>
                                                    
                                                    <button type="button" class="btn btn-primary float-right" value="Crea" onclick="creaElemento()"><i class="fas fa-plus mr-2"></i>Crea</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>

                                    <div id="divElencoElementi" class="col-lg-8 col-xl-9 mb-4 gerarchia-menu">
                                        <?php 
                                            $cruscotto->stampaElementi();
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <?php
                                }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </main>

        <?php
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";
            
            include "../include/modal/eliminaElemento.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";

            include "../include/jsBaseComponenti.php";
        ?>

        <script>
            function eliminaElemento(id,nomeElemento,tipoElemento) {
                $('#elementoDaEliminare').val(id);
                $('#nomeElementoDaEliminare').text(nomeElemento);
                $('#modalEliminaElemento').modal('show');
            }
            
            function eseguiEliminazioneElemento() {
                var id = $('#elementoDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"eliminaElemento",
                        id:<?php echo $cruscotto->getId() ?>,
                        idElemento:id
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            document.getElementById("elementoComponente"+id).className = "d-none";
                            $('#modalEliminaElemento').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function spostaElementoInput(id) {
                var posizione = $('#nuovaPosizioneElemento'+id).val();
                spostaElemento(id,posizione);
            }
            
            function spostaElemento(id,posizione) {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"spostaElemento",
                        id:<?php echo $cruscotto->getId() ?>,
                        idElemento:id,
                        posizione:posizione
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function creaElemento() {
                var nome   = $('#nomeElemento').val();
                var tipo   = $('#tipoElemento').val();
                var valore = $('#valoreElemento').val();
                
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"creaElemento",
                        id:<?php echo $cruscotto->getId() ?>,
                        nome:nome,
                        tipo:tipo,
                        valore:valore
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert("Si è verificato un errore, contatta l'amministratore del sito")
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function aggiornaDivElementi() {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"stampaElementi",
                        id:<?php echo $cruscotto->getId() ?>
                    },
                    success:function(result) {
                        document.getElementById("divElencoElementi").innerHTML = result;
                        $('#modifica-voce-menu').modal('hide');
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
        </script>
    </body>
</html>
